
final int ANZ = 40_000;

void testList(List<String> plis) {
    var sb = new StringBuilder();
    var ran = new Random();

    // Füllen
    IO.println("Kollektionsklasse:\t" + plis.getClass());
    var start = System.currentTimeMillis();
    for (int i = 0; i < ANZ; i++) {
        sb.delete(0, 6);
        for (int j = 0; j < 5; j++)
            sb.append((char) (65 + ran.nextInt(26)));
        plis.add(sb.toString());
    }
    System.out.printf(" %-50s %7d\n", "Zeit zum Füllen:",
            (System.currentTimeMillis() - start));

    // Abrufen per Index-Zugriff
    start = System.currentTimeMillis();
    for (int i = 0; i < ANZ; i++)
        plis.get(ran.nextInt(ANZ));
    System.out.printf(" %-50s %7d\n", "Zeit zum Abrufen:",
            (System.currentTimeMillis() - start));

    // Einfügen am Listenanfang
    start = System.currentTimeMillis();
    for (int i = 0; i < ANZ; i++)
        plis.add(0, "neu");
    System.out.printf(" %-50s %7d\n", "Zeit zum Einfügen am Anfang:",
            (System.currentTimeMillis() - start));

    // Einfügen an einer zufälligen Position
    start = System.currentTimeMillis();
    for (int i = 0; i < ANZ; i++)
        plis.add(ran.nextInt(ANZ), "neu");
    System.out.printf(" %-50s %7d\n", "Zeit zum Einfügen an einer zufälligen Pos.:",
            (System.currentTimeMillis() - start));

    // Löschen am Listenanfang
    start = System.currentTimeMillis();
    for (int i = 0; i < ANZ; i++)
        plis.remove(0);
    System.out.printf(" %-50s %7d\n", "Zeit zum Löschen am Anfang:",
            (System.currentTimeMillis() - start));
}

void main() {
    testList(new ArrayList<String>());
    testList(new ArrayList<String>());
    IO.println();
    testList(new LinkedList<String>());
    testList(new LinkedList<String>());
}
